/*
 * lxline-l.n.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_n_logique(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxline_type *dxline_data;
	struct lxline_type *lxline_data;
	struct lxtext_type *lxtext_data;
	void *data;

	lxtext_data = context;

	dxline_data = I_LINE(input[0]);

	lxline_data = lxtext_data->text;

	if (0) {
	} else {
	    status = _libx1f4i0_post_sfnote
		(dxline_data->line, I_TEXT(input[1]),
		 sizeof(struct fxdata_type) + 8, &data);
	    if (status) {
		status =
		    _libx1f4i0_lxline_stat_line(lxtext_data->text, status);
	    } else {
		unsigned link, type;
		void *post;

		type = lxtext_data->lxtype.code;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		status = lxtext_data->lxtype.post
		    (lxtext_data->lxtype.context, &post,
		     lock_excase(dxline_data));
		if (status) {
		    if (_libx1f4i0_pass_sfnote
			(dxline_data->line, I_TEXT(input[1]))) {
			link = ~0;
		    } else {
			lxline_data->link_m.free
			    (lxline_data->link_m.data, data);
			if (1) {
			    break;
			}
		    }
		} else {
		    l_USER(post, byte(data) + 8);

		    l_USER(post, output);

		    dxline_data->size++;

		    link = lxtext_data
			- ((struct lxtext_type *) lxline_data->link_f.text);
		}

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;
	    }
	}
    } while (0);

    return status;
}
