/*
 * lxline-l.d.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#if __HAVE_SHUT_SFNOTE__
static int shut_note(void *, void *);
#endif				/* __HAVE_SHUT_SFNOTE__ */

#if __HAVE_SHUT_SFNOTE__
static int
shut_note(void *text, void *data)
{
    int status = 0;
    unsigned link;

    link = byte(data)[4] << 030 | byte(data)[5] << 020 | byte(data)[6] << 010
	| byte(data)[7];
    if (~link) {
	int (*free) (void *, void *, struct excase_type **,
		     const struct excase_type *);
	struct lxtext_type *lxtext_link;

	lxtext_link =
	    ((struct lxtext_type *)
	     ((struct lxline_type *) *(void **) text)->link_f.text) + link;

	free = lxtext_link->lxtype.free;
	if (free) {
	    status = free
		(lxtext_link->lxtype.context, I_USER(byte(data) + 8), NULL,
		 lock_excase(*((void **) text + 1)));
	}
    }

    return status;
}
#endif				/* __HAVE_SHUT_SFNOTE__ */


int
_libx1f4i0_lxline_d_logique(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
#if __HAVE_SHUT_SFNOTE__
#else
    void *data;
#endif				/* __HAVE_SHUT_SFNOTE__ */
#if __HAVE_SHUT_SFNOTE__
    void *text[2];
#endif				/* __HAVE_SHUT_SFNOTE__ */

    dxline_data = I_LINE(input[0]);

    lxline_data = context;

    fail = I_TEXT(input[1]);

#if __HAVE_SHUT_SFNOTE__
    text[0] = lxline_data;
    text[1] = dxline_data;
#endif				/* __HAVE_SHUT_SFNOTE__ */

#if __HAVE_SHUT_SFNOTE__
    status = _libx1f4i0_shut_sfnote(dxline_data->line, fail, text, shut_note);
    if (status) {
	if (status == X1f4_SFNOTE_MISS_CLASS) {
	    status = _libx1f4i0_lxline_stat_miss(lxline_data, fail);
	} else {
# if 0
	    if (status == X1f4_SFNOTE_CALL_ERROR) {
		status = X1f4_EX_CRITICAL;
	    } else {
# endif				/* 0 */
		status = _libx1f4i0_lxline_stat_line(lxline_data, status);
# if 0
	    }
# endif				/* 0 */
	}
    } else {
	dxline_data->size--;
    }
#else
    status = _libx1f4i0_find_sfnote(dxline_data->line, fail, &data);
    if (status) {
	do {
	    unsigned link;

	    link = byte(data)[4] << 030 | byte(data)[5] << 020
		| byte(data)[6] << 010 | byte(data)[7];
	    if (~link) {
		int (*free) (void *, void *, struct excase_type **,
			     const struct excase_type *);
		struct lxtext_type *lxtext_link;

		lxtext_link =
		    ((struct lxtext_type *) lxline_data->link_f.text) + link;

		free = lxtext_link->lxtype.free;
		if (free) {
		    status = free
			(lxtext_link->lxtype.context,
			 I_USER(byte(data) + 8), NULL,
			 lock_excase(dxline_data));
		    if (status) {
			break;
		    }
		}
	    }

	    status = _libx1f4i0_pass_sfnote(dxline_data->line, fail);
	    if (status) {
		status = _libx1f4i0_lxline_stat_line(lxline_data, status);
	    } else {
		dxline_data->size--;
	    }
	} while (0);
    } else {
	status = _libx1f4i0_lxline_stat_miss(lxline_data, fail);
    }
#endif				/* __HAVE_SHUT_SFNOTE__ */

    return status;
}
