/*
 * lxline-f.u.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_REAL(t)			(*((X1f4_E4_C_REAL *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define l_REAL(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_u_forward(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    void *data;

    dxline_data = I_LINE(input[0]);

    status = _libx1f4i0_find_sfnote
	(dxline_data->line, I_TEXT(input[1]), &data);
    if (status) {
	unsigned type;

	status = 0;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];
	data += 8;
	switch (type) {
	case X1f4_E4_BILL:
	    l_BILL(I_BILL(data) + 1, data);
	    break;
	case X1f4_E4_MODE:
	    l_MODE(I_MODE(data) + 1, data);
	    break;
	case X1f4_E4_REAL:
	    l_REAL(I_REAL(data) + 1, data);
	    break;
	default:
	    status = _libx1f4i0_lxline_stat_flat
		(context, I_TEXT(input[1]));
	}
    } else {
	status = _libx1f4i0_lxline_stat_miss
	    (context, I_TEXT(input[1]));
    }

    return status;
}
