/*
 * lxline-f.s.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define __LOOSE_LINK__			1
#define __TIGHT_LINK__			2

#define __LINK_LOGIC__			__LOOSE_LINK__

#define ____LINK_LOGIC__		__LINK_LOGIC__

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_LINE(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxline_s_forward(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data, *dxline_text;
#if ____LINK_LOGIC__ == __TIGHT_LINK__
    void *deftext, *subtext;
#endif				/* ____LINK_LOGIC__ == __TIGHT_LINK__ */

    dxline_data = I_LINE(input[0]);
    dxline_text = I_LINE(input[1]);

#if ____LINK_LOGIC__ == __TIGHT_LINK__
    deftext = *nassa(context);
    subtext = context;
#endif				/* ____LINK_LOGIC__ == __TIGHT_LINK__ */

#if ____LINK_LOGIC__ == __LOOSE_LINK__
    lock_exline(dxline_text)->call++;
#endif				/* ____LINK_LOGIC__ == __LOOSE_LINK__ */

#if ____LINK_LOGIC__ == __LOOSE_LINK__
    status = _libx1f4i0_lxline_side_line
	(context, dxline_data);
    if (status) {
	lock_exline(dxline_text)->call--;
	_libx1f4i0_lxline_link_line
	    (context, input[0]);
    } else {
	l_LINE(dxline_text, input[0]);
	l_LINE(dxline_text, output);
    }
#elif __LINK_LOGIC__ == __TIGHT_LINK__
    status = _libx1f4i0_lxline_deck_line
	(deftext, subtext, NULL, dxline_data, dxline_text);
    if (status) {
    } else {
	status = _libx1f4i0_lxline_side_line(subtext, dxline_data);
	if (status) {
	    _libx1f4i0_lxline_link_line(context, input[0]);
	} else {
	    l_LINE(dxline_text, input[0]);
	    l_LINE(dxline_text, output);

	    lock_exline(dxline_text)->call++;
	}
    }
#endif				/* ____LINK_LOGIC__ == __LOOSE_LINK__ */

    return status;
}
