/*
 * lxline-f.n.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_LINE(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxline_n_forward(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;

    dxline_data = I_LINE(input[0]);

    if (lock_exline(dxline_data)->call == 1) {
	if (!dxline_data->size) {
	    status = 0;
	} else {
	    status = _libx1f4i0_lxline_null_line
		(context, NULL, dxline_data);
	}
    } else {
	void *subtext;

	subtext = context;

	status = _libx1f4i0_lxline_side_line(subtext, dxline_data);
	if (status) {
	} else {
	    status = _libx1f4i0_lxline_line_line(subtext, input[0]);
	    if (status) {
		l_LINE(NULL, input[0]);
	    }
	}
    }

    return status;
}
