/*
 * lxline-f.h.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxline_h_forward(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    void *data;

    dxline_data = I_LINE(input[0]);

    status = _libx1f4i0_lead_sfnote(dxline_data->line, &data);
    if (status) {
	status = _libx1f4i0_lxline_stat_line(context, status);
    } else {
	status = _libx1f4i0_lxline_fine_data
	    (context, output, data, dxline_data);
    }

    return status;
}
