/*
 * lxline-e.l.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <retain.h>

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#if __RETAIN_OBJECT_DATA__
typedef struct upcast_type {
    int (*slip) (void *, void *, void **);
    struct x1f4_dxcast_type dxcast;
    void *text;
} upcast_type;
#endif				/* __RETAIN_OBJECT_DATA__ */

#if __RETAIN_OBJECT_DATA__
static int slip_object(void *, void *);
#endif				/* __RETAIN_OBJECT_DATA__ */

#if __RETAIN_OBJECT_DATA__
static int
slip_object(void *context, void *upcast)
{
    int (*slip) (void *, void *, void **), status;
    struct upcast_type *upcast_data;

    upcast_data = upcast;

    slip = upcast_data->slip;
    if (slip) {
	status = slip
	    (context, upcast_data->text, (void *) &upcast_data->dxcast.data);
    } else {
	status = 0;
    }

    return status;
}
#endif				/* __RETAIN_OBJECT_DATA__ */


int
_libx1f4i0_lxline_fine_data(void *context, void *output, const void *data,
			    void *dxline)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
#if __RETAIN_OBJECT_DATA__
    struct lxtext_type *lxtext_data;
    unsigned link;
#endif				/* __RETAIN_OBJECT_DATA__ */
    void *cast;

    dxline_data = dxline;

    lxline_data = context;

#if __RETAIN_OBJECT_DATA__
    link = byte(data)[4] << 030 | byte(data)[5] << 020 | byte(data)[6] << 010
	| byte(data)[7];
#endif				/* __RETAIN_OBJECT_DATA__ */

#if __RETAIN_OBJECT_DATA__
    if (~link) {
	lxtext_data = lxline_data->link_f.text;
	lxtext_data += link;
	if (lxtext_data->lxtype.lead) {
	} else {
	    link = 0;
	}
    } else {
	link = 0;
    }
#endif				/* __RETAIN_OBJECT_DATA__ */

#if __RETAIN_OBJECT_DATA__
    if (link) {
	void **mind;

	status = lxline_data->link_v.pick
	    (lxline_data->link_v.data, &mind, slip_object,
	     sizeof(struct upcast_type), &cast);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	} else {
	    struct upcast_type *upcast_data;

	    upcast_data = cast;

	    *mind = cast;

	    status = lxtext_data->lxtype.lead
		(lxtext_data->lxtype.context, (void *) (byte(data) + 8));
	    if (status) {
		upcast_data->slip = NULL;
	    } else {
		struct x1f4_dxcast_type *dxcast_data;
		unsigned type;

		cast = &upcast_data->dxcast;

		dxcast_data = cast;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];

		l_USER(cast, output);

		dxcast_data->call = 1;
		dxcast_data->type = type;

		copy_miss(&dxcast_data->data, type, byte(data) + 8);

		upcast_data->slip = lxtext_data->lxtype.slip;
		upcast_data->text = lxtext_data->lxtype.context;
	    }
	}
    } else {
#elif 0
    }
#else
    {
#endif				/* __RETAIN_OBJECT_DATA__ */
	unsigned type;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];

#if __RETAIN_OBJECT_DATA__
	if (X1f4_E4_LAST < type && type < X1f4_E4_CALL) {
	    status = _libx1f4i0_lxline_stat_lead(lxline_data, type);
	} else {
#endif				/* __RETAIN_OBJECT_DATA__ */
	    status = lxline_data->link_v.link
		(lxline_data->link_v.data, &cast,
		 sizeof(struct x1f4_dxcast_type));
	    if (status) {
		status = _libx1f4i0_lxline_stat_link(lxline_data);
	    } else {
		struct x1f4_dxcast_type *dxcast_data;

		dxcast_data = cast;

		l_USER(cast, output);

		dxcast_data->call = 0;
		dxcast_data->type = type;

		copy_miss(&dxcast_data->data, type, byte(data) + 8);
	    }
#if __RETAIN_OBJECT_DATA__
	}
#endif				/* __RETAIN_OBJECT_DATA__ */
    }

    return status;
}
