/*
 * lxline-e.e.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxlead.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <tcvset.h>

#define lxline(line) \
    ((struct lxline_type *) (line))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_pick_lxline(void *subtext, void *dxline, struct excase_type **excase,
		 const struct excase_type *excase_data)
{
    int status;
    unsigned call;

    call = lock_exline(dxline)->call;

    if (call) {
	call--;
	if (call) {
	    status = tccase(lock_exline(dxline)->text)->miss
		(&lock_exline(dxline)->pset, &lock_exline(dxline)->text,
		 excase_data, (void *) &lxline(subtext)->link_m);
	    if (status) {
		status = X1f4_EX_CRITICAL;
	    } else {
		int (*fine) (void *, struct x1f4_nodelink_type **,
			     struct x1f4_nodelink_type *);

		lock_exline(dxline)->call = call;

		fine = lxline(subtext)->link_r.fine;
		if (fine) {
		    status = fine
			(lxline(subtext)->link_r.text, excase,
			 lock_excase(dxline));
		} else {
		    x1f4_side_lxlead(excase, dxline);
		}
	    }
	} else {
	    status = 0;
	    if (lock_excase(dxline)->slip) {
	    } else {
		lock_exline(dxline)->call = 0;
		lock_excase(dxline)->slip = *excase;
		*excase = lock_excase(dxline);
	    }
	}
    } else {
	status = 0;
    }

    return status;
}
