/*
 * lxline-e.d.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <cl.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <trans.h>

#define dxline(line) \
    ((struct dxline_type *) (line))

int
x1f4_pull_lxline(void *subtext, void *bqpp, void *dxline,
		 const void *line, struct trans_type *trans_data,
		 struct x1f4_caselink_type **caselink)
{
    int status;
    void *becca[6];

    becca[0] = subtext;
    becca[1] = NULL;
    becca[2] = dxline;
    becca[3] = bqpp;
    becca[4] = trans_data;
    becca[5] = *caselink;

    status = _libx1f4i0_line_sfnote
	(dxline(dxline)->line, dxline(line)->line, _libx1f4i0_lxline_size_link,
	 _libx1f4i0_lxline_copy_link, _libx1f4i0_lxline_free_link, becca);
    if (status) {
	status = _libx1f4i0_lxline_stat_line(subtext, status);
    } else {
	dxline(dxline)->size = dxline(line)->size;
    }

    *caselink = becca[5];

    return status;
}
