/*
 * lxline-e.b.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxline-types.h>
#include <tcvset.h>

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_node_lxline(void *subtext, void **copy, void *line,
		 const struct excase_type *excase_data)
{
    int status;

    status = tccase(lock_exline(line)->text)->push
	(&lock_exline(line)->pset, &lock_exline(line)->text, excase_data,
	 (void *) &((struct lxline_type *) subtext)->link_m);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	*copy = (void *) line;

	lock_exline(line)->call++;
    }

    return status;
}
