/*
 * lxline-d.t.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

/*
 * this was never tested with sfnote, I expect it does not work.
 */

#if __DISABLE_R_TRAVERSE__
#else

#include <copy.h>
#include <e4.h>
#include <l_note.h>
#include <lxcast.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#define dxline(line) \
    ((struct dxline_type *) (line))

typedef struct lead_type {
    union {
	X1f4_E4_C_BILL bill;
	X1f4_E4_C_MODE mode;
	X1f4_E4_C_REAL real;
	X1f4_E4_C_TEXT text;
    } data;
} wide_type;

typedef struct pick_type {
    int (*function) (void *, void *, void **);
    struct x1f4_dxcast_type dxcast;
    void *context, *input[2], *store[2], *transfer;
    wide_type output;
} pick_type;

extern const void *const x1f4_a1_walk_link;

static int line_call(void *, void *, struct x1f4_dispatch_type **);
static int line_deck(struct lxline_type *, struct dxline_type *, void **,
		     void **);
static int lose_node(struct lxnode_type *);
static int pick_line(void *, void *);

static int
line_call(void *node, void *output, struct x1f4_dispatch_type **dispatch)
{
    const char *miss;
    int status;
    struct lxnode_type *lxnode_data;
    unsigned size;
    void *data;

    lxnode_data = node;

    miss = lxnode_data->miss;

    status = _libx1f4i0_fgxq_sfnote
	(lxnode_data->line, miss, &data, &miss, &size);
    if (status) {
	int type;

	lxnode_data->miss = (void *) miss;

	*dispatch = &lxnode_data->dispatch;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];

	lxnode_data->dxcast.type = type;

	copy_miss(&lxnode_data->dxcast.data, type, byte(data) + 8);
    } else {
	if (0) {
	} else {
	    *dispatch = NULL;
	    if (1) {
		status = lose_node(lxnode_data);
	    }
	}
    }

    return status;
}


static int
line_deck(struct lxline_type *lxline_data, struct dxline_type *dxline_data,
	  void **class, void **input)
{
    int status;
    void *node;

    status = lxline_data->link_m.link
	(lxline_data->link_m.data, &node,
	 sizeof(struct lxnode_type) + sizeof(struct lead_type));
    if (status) {
	status = _libx1f4i0_lxline_stat_link(lxline_data);
    } else {
	struct lxnode_type *lxnode_data;
	const char *miss;

	lxnode_data = node;

	if (0) {
	} else {
	    unsigned size;
	    void *data;

	    lxnode_data->fail = 0100;

	    status = _libx1f4i0_hike_sfnote
		(dxline_data->line, &data, &miss, &size);
	    if (status) {
		status = _libx1f4i0_lxline_stat_line(lxline_data, status);
	    } else {
		int type;
		struct lxnode_type *last_lxnode;
		struct x1f4_linetext_type *linetext_data;

		lxnode_data->miss = (void *) miss;

		linetext_data = I_USER(class[2]);

		input[2] = &lxnode_data->dispatch;

		lxnode_data->dispatch.transfer.context =
		    (void *) linetext_data->context;
		lxnode_data->dispatch.transfer.function_data =
		    &linetext_data->function;
		lxnode_data->dispatch.transfer.input = lxnode_data->input;
		lxnode_data->dispatch.transfer.output = lxnode_data + 1;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];

		lxnode_data->transfer = &lxnode_data->dxcast;

		lxnode_data->dxcast.type = type;

		copy_miss(&lxnode_data->dxcast.data, type, byte(data) + 8);

		lxnode_data->input[0] = class[1];
		lxnode_data->input[1] = &lxnode_data->transfer;

		lxnode_data->dispatch.back = lxnode_data;
		lxnode_data->dispatch.call = line_call;

		lxnode_data->line = dxline_data->line;

		lxnode_data->lxline = lxline_data;

		lxnode_data->post_lxnode = NULL;

		last_lxnode = lxline_data->link_k.node;

		lxline_data->link_k.node = lxnode_data;

		if (last_lxnode) {
		    last_lxnode->post_lxnode = lxnode_data;
		    lxnode_data->last_lxnode = last_lxnode;
		} else {
		    lxnode_data->last_lxnode = NULL;
		}
	    }
	}

	if (status) {
	    lxline_data->link_m.free(lxline_data->link_m.data, node);
	}
    }

    return status;
}


static int
lose_node(struct lxnode_type *lxnode_data)
{
    int excess, status;
    struct lxline_type *lxline_data;
    struct lxnode_type *last_lxnode;

    lxline_data = lxnode_data->lxline;

    last_lxnode = lxnode_data->last_lxnode;

    if (lxnode_data == lxline_data->link_k.node) {
	lxline_data->link_k.node = last_lxnode;

	if (last_lxnode) {
	    last_lxnode->post_lxnode = NULL;
	}
    } else {
	struct lxnode_type *post_lxnode;

	post_lxnode = lxnode_data->post_lxnode;

	if (last_lxnode) {
	    last_lxnode->post_lxnode = post_lxnode;
	}

	if (1) {
	    post_lxnode->last_lxnode = last_lxnode;
	}
    }

    status = lxline_data->link_m.free
	(lxline_data->link_m.data, lxnode_data->miss);
    if (status) {
	status = _libx1f4i0_lxline_stat_free(lxline_data);
    }

    excess = lxline_data->link_m.free(lxline_data->link_m.data, lxnode_data);
    if (excess) {
	excess = _libx1f4i0_lxline_stat_free(lxline_data);
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}


static int
pick_line(void *text, void *data)
{
    int type;
    struct pick_type *pick_data;

    pick_data = text;

    type = byte(data)[0] << 030 | byte(data)[1] << 020 | byte(data)[2] << 010
	| byte(data)[3];

    pick_data->dxcast.type = type;

    copy_miss(&pick_data->dxcast.data, type, byte(data) + 8);

    return pick_data->function
	(pick_data->context, &pick_data->output, pick_data->input);
}


int
_libx1f4i0_lxline_t_derived(void *context, void *output, void **input)
{
    int status;

    if (output == x1f4_a1_walk_link) {
	struct dxline_type *dxline_data;
	void **class;

	class = input[1];

	dxline_data = I_LINE(class[0]);
	if (_libx1f4i0_case_sfnote(dxline_data->line)) {
	    status = line_deck(context, dxline_data, class, input);
	} else {
	    status = 0;
	    if (1) {
		input[2] = NULL;
	    }
	}
    } else {
	struct pick_type pick;
	struct x1f4_linetext_type *linetext_data;

	pick.transfer = &pick.dxcast;

	pick.input[0] = input[1];
	pick.input[1] = &pick.transfer;

	linetext_data = I_USER(input[2]);

	pick.function = linetext_data->function.function;

	if (linetext_data->function.flags & X1f4_E4_TEXT_LINK) {
	    pick.store[0] = (void *) linetext_data->context;
	    pick.store[1] = *nassa(context);

	    pick.context = pick.store;
	} else {
	    pick.context = *nassa(context);
	}

	status = _libx1f4i0_lime_sfnote
	    (dxline(I_LINE(input[0]))->line, &pick, pick_line);
    }

    return status;
}

#endif				/* __DISABLE_R_TRAVERSE__ */
