/*
 * lxline-a.v.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxline-types.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#define becca(context) \
    ((void **) (context))
#define scope(context) \
    (becca((context)) + 2)

#define lxline(line) \
    ((struct lxline_type *) (line))

int
_libx1f4i0_lxline_free_link(void *context, void *line)
{
    int status = 0;
    struct lxline_type *lxline_data;
    unsigned link;

    lxline_data = *becca(context);

    link = byte(line)[4] << 030 | byte(line)[5] << 020 | byte(line)[6] << 010
	| byte(line)[7];
    if (~link) {
	int (*free) (void *, void *, struct x1f4_nodelink_type **,
		     const struct excase_type *);
	struct lxtext_type *lxtext_link;

	lxtext_link = (struct lxtext_type *) lxline_data->link_f.text + link;

	free = lxtext_link->lxtype.free;
	if (free) {
	    status = free
		(lxtext_link->lxtype.context,
		 I_USER(byte(line) + 8), NULL, lock_excase(*scope(context)));
	}
    }

    return status;
}
