/*
 * lxline-a.t.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <l_note.h>
#include <lxfset.h>
#include <lxlead.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define dxline(line) \
    ((struct dxline_type *) (line))
#define lxline(line) \
    ((struct lxline_type *) (line))

int
_libx1f4i0_lxline_late_line(void *subtext, void *late, void *copy,
			    const void *line)
{
    int status;
    struct lxline_type *lxline_data;

    lxline_data = subtext;

    if (1) {
	void *becca[6];

	becca[0] = subtext;
	becca[2] = late;

	status = x1f4_init_lxfset(becca + 3);
	if (status) {
	    status = _libx1f4i0_lxline_stat_link(lxline_data);
	} else {
	    int excess;
	    void **node, *record;

	    status = x1f4_post_lxfset(becca[3], &line, &record);
	    if (status) {
		status = _libx1f4i0_lxline_stat_link(lxline_data);
	    } else {
		node = record;

		node[0] = (void *) line;
		node[1] = late;

		becca[4] = &lxline_data->link_m;
		becca[5] = NULL;

		status = _libx1f4i0_line_sfnote
		    (dxline(copy)->line, dxline(line)->line,
		     _libx1f4i0_lxline_size_link, _libx1f4i0_lxline_copy_link,
		     _libx1f4i0_lxline_free_link, becca);
		if (status) {
		    status = _libx1f4i0_lxline_stat_line(lxline_data, status);

		    x1f4_lose_lxlead(becca[5], &lxline_data->link_m);
		} else {
		    dxline(copy)->size = dxline(line)->size;

		    status = x1f4_beta_lxlead
			(becca[3], becca[5], &lxline_data->link_m);
		}
	    }

	    excess = x1f4_fini_lxfset(becca + 3);
	    if (excess) {
		excess = _libx1f4i0_lxline_stat_free(lxline_data);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}
