/*
 * lxline-a.s.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

int
_libx1f4i0_lxline_fast_line(void *lxline, void *dxline)
{
    int status;
    struct lxline_type *lxline_data;

	struct x1f4_sfnote_type sfnote;

    lxline_data = lxline;

	sfnote.trans = &lxline_data->link_m;

	((struct dxline_type *) dxline)->line = post_dxline(dxline);

	status = _libx1f4i0_fast_sfnote
	    (((struct dxline_type *) dxline)->line, X1f4_SFNOTE_TRANS_MASK,
	     &sfnote);
	if (status) {
	    status = _libx1f4i0_lxline_stat_line(lxline_data, status);
	}

    return status;
}
