/*
 * lxline-a.e.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <integral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <l_note.h>
#if !defined HAVE_LIBx1f4i0
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxline-inter.h>
#include <lxline-types.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define lxline(lxline) \
    ((struct lxline_type *) (lxline))

static int make_type(void *, void *, int (*) (void *, const char *, unsigned),
		     unsigned);

static int
make_type(void *lxline, void *data,
	  int (*push) (void *, const char *, unsigned), unsigned type)
{
    return x1f4_dump_type
	(data, push, type, lxline(lxline)->trap_e.eelookup_data);
}


int
_libx1f4i0_lxline_stat_copy(void *lxline)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "cannot copy/link/move line for non self inc"
			  "lusion rules say so", 62);
	    if (status) {
		break;
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_deck(void *lxline, unsigned size, long mode)
{
    int status;

    if (size) {
	status = _libx1f4i0_lxline_stat_time(lxline, size, mode);
    } else {
	status = _libx1f4i0_lxline_stat_null(lxline);
    }

    return status;
}


int
_libx1f4i0_lxline_stat_ends(void *lxline, int tail, unsigned found,
			    unsigned expected)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "mismatched type (", 17);
	    if (status) {
		break;
	    } else {
		status = make_type(lxline, data, push, found);
		if (status) {
		    break;
		} else {
		    status = push(data, " found, ", 8);
		    if (status) {
			break;
		    } else {
			status = make_type(lxline, data, push, expected);
			if (status) {
			    break;
			} else {
			    status = push(data, " expected) for ", 15);
			    if (status) {
				break;
			    } else {
				if (tail) {
				    status = push(data, "last", 4);
				} else {
				    status = push(data, "first", 5);
				}
				if (status) {
				    break;
				} else {
				    status = push(data, " key", 4);
				    if (status) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_ever(void *lxline)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "key exists", 10);
	    if (status) {
		break;
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_flat(void *lxline, const char *text)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "numeric type expected for the `", 31);
	    if (status) {
		break;
	    } else {
		status = push(data, text, strlen(text));
		if (status) {
		    break;
		} else {
		    status = push(data, "' key", 5);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_free(void *lxline)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxline_stat_lead(void *lxline, unsigned type)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push
		(data, "will not box non referable, non intrinsic object of"
		 " type ", 57);
	    if (status) {
		break;
	    } else {
		status = make_type(lxline, data, push, type);
		if (status) {
		    break;
		}
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_link(void *lxline)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxline_stat_line(void *lxline, int error)
{
    int status;

    if (error == X1f4_SFNOTE_DECK_ERROR) {
	status = _libx1f4i0_lxline_stat_null(lxline);
    } else {
	if (error == X1f4_SFNOTE_EVER_MATCH) {
	    status = _libx1f4i0_lxline_stat_ever(lxline);
	} else {
	    if (error == X1f4_SFNOTE_FREE_ERROR) {
		status = _libx1f4i0_lxline_stat_free(lxline);
	    } else {
		if (error == X1f4_SFNOTE_LINK_ERROR) {
		    status = _libx1f4i0_lxline_stat_link(lxline);
		} else {
		    if (error == X1f4_SFNOTE_MODE_ERROR) {
			status = _libx1f4i0_lxline_stat_mode(lxline);
		    } else {
			status = X1f4_EX_CRITICAL;
		    }
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxline_stat_miss(void *lxline, const char *text)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "no mapping for key `", 20);
	    if (status) {
		break;
	    } else {
		status = push(data, text, strlen(text));
		if (status) {
		    break;
		} else {
		    status = push(data, "'", 1);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_mode(void *lxline)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "cannot reallocate memory", 24);
	    if (status) {
		break;
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxline_stat_null(void *lxline)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "void record", 11);
	    if (status) {
		break;
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_post(void *lxline, const char *text)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "key `", 5);
	    if (status) {
		break;
	    } else {
		status = push(data, text, strlen(text));
		if (status) {
		    break;
		} else {
		    status = push(data, "' exists", 8);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_text(void *lxline, int error, const char *text)
{
    int status;

    if (error == X1f4_SFNOTE_EVER_MATCH) {
	status = _libx1f4i0_lxline_stat_post(lxline, text);
    } else {
	if (1) {
	    status = _libx1f4i0_lxline_stat_line(lxline, error);
	}
    }

    return status;
}


int
_libx1f4i0_lxline_stat_time(void *lxline, unsigned size, long mode)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "out of valid range (-", 21);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dcardinal(data, push, size);
		if (status) {
		    break;
		} else {
		    status = push(data, " .. ", 4);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dcardinal(data, push, size - 1);
			if (status) {
			    break;
			} else {
			    status = push(data, ") index (", 9);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_dlintegral
				    (data, push, mode);
				if (status) {
				    break;
				} else {
				    status = push(data, ")", 1);
				    if (status) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_type(void *lxline, const char *text, unsigned found,
			    unsigned expected)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxline(lxline)->link_e.data;

	line = lxline(lxline)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxline(lxline)->link_e.push;
	if (push) {
	    status = push(data, "mismatched type (", 17);
	    if (status) {
		break;
	    } else {
		status = make_type(lxline, data, push, found);
		if (status) {
		    break;
		} else {
		    status = push(data, " found, ", 8);
		    if (status) {
			break;
		    } else {
			status = make_type(lxline, data, push, expected);
			if (status) {
			    break;
			} else {
			    status = push(data, " expected) for `", 16);
			    if (status) {
				break;
			    } else {
				status = push(data, text, strlen(text));
				if (status) {
				    break;
				} else {
				    status = push(data, "' key", 5);
				    if (status) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxline(lxline)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
