/*
 * lxline-a.b.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <stddef.h>

#include <exerrors.h>
#include <l_note.h>
#include <lxfset.h>
#include <lxlead.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <tcvset.h>

#define dxline(line) \
    ((struct dxline_type *) (line))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_copy_lxline(void *subtext, void *bppp, void **copy,
		 const void *line, const struct excase_type *excase_data)
{
    int status;
    struct lxline_type *lxline_data;
    unsigned call;
    void *dxline;

    lxline_data = subtext;

    _libx1f4i0_call_sfnote(&call);

    status = lxline_data->link_m.link
	(lxline_data->link_m.data, &dxline,
	 __struct_dxline_type_alloc_size__ + call);
    if (status) {
	status = _libx1f4i0_lxline_stat_link(lxline_data);
    } else {
	void *bqpp;

	do {
	    void *record;

	    if (bppp) {
		bqpp = bppp;
	    } else {
		status = x1f4_init_lxfset(&bqpp);
		if (status) {
		    status = _libx1f4i0_lxline_stat_link(lxline_data);
		    if (1) {
			break;
		    }
		}
	    }

	    status = x1f4_post_lxfset(bqpp, &line, &record);
	    if (status) {
		status = _libx1f4i0_lxline_stat_link(lxline_data);
		if (1) {
		    break;
		}
	    } else {
		void *pset;
		const void *text;

		dxline = pick_dxline(dxline);

		{
		    {
			void **node;

			node = record;
			node[0] = (void *) line;
			node[1] = dxline;
		    }
		}

		lock_excase(dxline)->nodetype_data = lxline_data->link_n.node;

		lock_excase(dxline)->slip = NULL;

		lock_exline(dxline)->call = 1;

		_libx1f4i0_init_tcvset(&pset, &text);

		status = tccase(text)->push
		    (&pset, &text, excase_data, (void *) &lxline_data->link_m);
		if (status) {
		    status = X1f4_EX_CRITICAL;

		    _libx1f4i0_fini_tcvset
			(&pset, &text, (void *) &lxline_data->link_m);
		} else {
		    void *becca[6];

		    lock_exline(dxline)->pset = pset;
		    lock_exline(dxline)->text = text;

		    becca[0] = subtext;
		    becca[1] = NULL;
		    becca[2] = dxline;
		    becca[3] = bqpp;
		    becca[4] = &lxline_data->link_m;
		    becca[5] = NULL;

		    status = _libx1f4i0_lxline_fast_line(subtext, dxline);
		    if (status) {
		    } else {
			status = _libx1f4i0_line_sfnote
			    (dxline(dxline)->line, dxline(line)->line,
			     _libx1f4i0_lxline_size_link,
			     _libx1f4i0_lxline_copy_link,
			     _libx1f4i0_lxline_free_link, becca);
			if (status) {
			    status = _libx1f4i0_lxline_stat_line
				(lxline_data, status);

			    _libx1f4i0_flat_sfnote
				(((struct dxline_type *) dxline)->line);
			}
		    }
		    if (status) {
			x1f4_lose_lxlead(becca[5], &lxline_data->link_m);

			_libx1f4i0_fini_tcvset
			    (&pset, &text, (void *) &lxline_data->link_m);
		    } else {
			dxline(dxline)->size = dxline(line)->size;

			status = x1f4_beta_lxlead
			    (bqpp, becca[5], &lxline_data->link_m);
			if (status) {
			    _libx1f4i0_lxline_side_line(lxline_data, dxline);
			} else {
			    *copy = dxline;
			}

			dxline = NULL;
		    }
		}
	    }
	} while (0);

	if (bqpp) {
	    if (bppp) {
	    } else {
		int excess;

		excess = x1f4_fini_lxfset(&bqpp);
		if (excess) {
		    excess = _libx1f4i0_lxline_stat_free(lxline_data);

		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}

	if (dxline) {
	    lxline_data->link_m.free
		(lxline_data->link_m.data, lock_cxline(dxline));
	}
    }

    return status;
}
