/*
 * lxline-a.1.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <lxline-defs.h>
#include <lxline-types.h>

static int fini_line(struct lxline_type *);
#if __DISABLE_R_TRAVERSE__
#else
static int free_node(struct lxline_type *);
#endif				/* __DISABLE_R_TRAVERSE__ */

static int
fini_line(struct lxline_type *lxline_data)
{
    int (*free) (void *, void *), status;
    void *data;

#if __DISABLE_R_TRAVERSE__
    status = 0;
#else
    status = free_node(lxline_data);
#endif				/* __DISABLE_R_TRAVERSE__ */

    data = lxline_data->link_w.data;
    free = lxline_data->link_w.free;

    if (free(data, lxline_data->link_f.data)) {
	status = FREE_ERROR;
    }

    if (free(data, lxline_data)) {
	status = FREE_ERROR;
    }

    return status;
}


#if __DISABLE_R_TRAVERSE__
#else
static int
free_node(struct lxline_type *lxline_data)
{
    int status = 0;
    struct lxnode_type *lxnode_data;

    lxnode_data = lxline_data->link_k.node;
    if (lxnode_data) {
	int (*free) (void *, void *);
	void *data;

	data = lxline_data->link_m.data;
	free = lxline_data->link_m.free;

	do {
	    struct lxnode_type *last_lxnode;

	    last_lxnode = lxnode_data->last_lxnode;

	    if (free(data, lxnode_data)) {
		status = FREE_ERROR;
	    }

	    lxnode_data = last_lxnode;
	} while (lxnode_data);
    }

    return status;
}
#endif				/* __DISABLE_R_TRAVERSE__ */


int
x1f4_fini_lxline(void **lxline)
{
    return fini_line(*lxline);
}
