/*
 * lxlead-e.p.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <cl.h>
#include <exerrors.h>
#include <nt.h>
#include <trans.h>

int
x1f4_beta_lxlead(void *bqpp, struct x1f4_caselink_type *caselink_data,
		 struct trans_type *trans_data)
{
    int status = 0;

    while (caselink_data) {
	struct x1f4_caselink_type *caselink_text;
	struct x1f4_nodetype_type *nodetype_data;

	caselink_text = caselink_data->caselink_data;

	nodetype_data = caselink_data->nodetype_data;

	status = nodetype_data->pull
	    (nodetype_data->context, bqpp, caselink_data->data,
	     caselink_data->text, trans_data, &caselink_text);
	if (status) {
	    break;
	} else {
	    status = trans_data->free(trans_data->data, caselink_data);
	    if (status) {
		status = X1f4_EX_CRITICAL;
		break;
	    } else {
		caselink_data = caselink_text;
	    }
	}
    }

    while (caselink_data) {
	struct x1f4_caselink_type *caselink_text;

	caselink_text = caselink_data->caselink_data;

	trans_data->free(trans_data->data, caselink_data);

	caselink_data = caselink_text;
    }

    return status;
}
