/*
 * lxlead-e.f.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxlead-inter.h>
#include <nl.h>

int
x1f4_mind_lxlead(struct x1f4_nodelink_type **excase, void *dxlist)
{
    int linked, status;
    struct x1f4_nodelink_type *excase_text = NULL;

    linked = x1f4_long_lxlead(&excase_text, dxlist);
    if (linked) {
	status = 0;
    } else {
	struct x1f4_nodelink_type *excase_data, *excase_slip;

	excase_data = excase_text;
	if (excase) {
	    while (1) {
		excase_data->nodetype_data->call(excase_data);
		excase_slip = excase_data->slip;
		if (excase_slip) {
		    excase_slip->nodetype_data->call(excase_slip);
		    excase_data = excase_slip->slip;
		    if (excase_data) {
		    } else {
			break;
		    }
		} else {
		    excase_slip = excase_data;
		    if (1) {
			break;
		    }
		}
	    }
	} else {
	    do {
		excase_data->nodetype_data->call(excase_data);
		excase_data = excase_data->slip;
	    } while (excase_data);

	    excase_slip = NULL;
	}

	if (0) {
	} else {
	    if (excase) {
		excase_slip->slip = *excase;
		*excase = excase_text;
		status = 0;
	    } else {
		status = x1f4_fail_lxlead(excase_text);
	    }
	}
    }

    return status;
}
