/*
 * lxflat-f.s.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxflat-inter.h>
#include <lxflat-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_DATA(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lock_exdata(data) \
    (data)

int
_libx1f4i0_lxflat_s_forward(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxflat_type *dxflat_data, *dxflat_text;
	unsigned call;

	dxflat_data = I_DATA(input[0]);
	dxflat_text = I_DATA(input[1]);

	lock_exdata(dxflat_text)->call++;

	call = dxflat_data->call;
	call--;
	if (call) {
	    dxflat_data->call = call;

	    status = 0;
	} else {
	    status = _libx1f4i0_lxflat_side_flat(context, dxflat_data);
	    if (status) {
		lock_exdata(dxflat_text)->call--;
		_libx1f4i0_lxflat_link_flat(context, input[0]);
		if (1) {
		    break;
		}
	    } else {
	    }
	}

	l_DATA(dxflat_text, input[0]);
	l_DATA(dxflat_text, output);
    } while (0);

    return status;
}
