/*
 * lxflat-e.k.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxflat-defs.h>
#include <lxflat-inter.h>
#include <lxflat-types.h>
#include <lxwide.h>

int
x1f4_tile_lxflat(void **lxflat, unsigned bits,
		 struct x1f4_lxwide_type *lxwide_data, unsigned tile,
		 const void *data)
{
    int status;
    struct screen_type screen;
    unsigned flags;

    if (1) {
	screen = *(const struct screen_type *) data;
    }

    flags = tile;

    if (1) {
	lxwide_data->widetype_set.type += screen.link_l.miss;
    }

    if (bits & X1f4_LXWIDE_CODELINK) {
	if (flags & CODELINK_LINK) {
	} else {
	    flags |= CODELINK_LINK;
	    screen.link_w.data = lxwide_data->codelink_set.data;
	    screen.link_w.free = lxwide_data->codelink_set.free;
	    screen.link_w.link = lxwide_data->codelink_set.link;
	    screen.link_w.mode = lxwide_data->codelink_set.mode;
	}
    }

    if (bits & X1f4_LXWIDE_RESOURCE) {
	if (flags & RESOURCE_LINK) {
	} else {
	    flags |= RESOURCE_LINK;
	    screen.link_m.data = lxwide_data->resource_set.data;
	    screen.link_m.free = lxwide_data->resource_set.free;
	    screen.link_m.link = lxwide_data->resource_set.link;
	    screen.link_m.mode = lxwide_data->resource_set.mode;
	}
    }

    if (bits & X1f4_LXWIDE_TEXTFLAT) {
	if (flags & TEXTFLAT_LINK) {
	} else {
	    flags |= TEXTFLAT_LINK;
	    screen.link_e.data = lxwide_data->textflat_set.data;
	    screen.link_e.line = lxwide_data->textflat_set.line;
	    screen.link_e.post = lxwide_data->textflat_set.post;
	    screen.link_e.push = lxwide_data->textflat_set.push;
	}
    }

    status = _libx1f4i0_lxflat_init_flat(lxflat, flags, &screen);
    if (status) {
    } else {
    }

    return status;
}
