/*
 * lxflat-a.g.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxflat-inter.h>
#include <lxflat-types.h>

extern const char *const x1f4_c1_empty_string;

int
x1f4_line_lxflat(void *subtext, void **address)
{
    int status;
    struct lxflat_type *lxflat_data;
    void *dxflat;

    lxflat_data = subtext;

    status = lxflat_data->link_m.link
	(lxflat_data->link_m.data, &dxflat, sizeof(struct dxflat_type));
    if (status) {
	status = _libx1f4i0_lxflat_stat_link(lxflat_data);
    } else {
	((struct dxflat_type *) dxflat)->call = 1;

	((struct dxflat_type *) dxflat)->data = NULL;

	*address = dxflat;
    }

    return status;
}
