/*
 * lxflat-a.f.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxflat-inter.h>
#include <nt.h>

int
x1f4_type_lxflat(const void *screen, struct x1f4_nodetype_type *nodetype_data,
		 int cflat3)
{
    struct cxflat_type *cxflat_data;
    const struct screen_type *screen_data;
    unsigned miss;

    screen_data = screen;

    cxflat_data = screen_data->link_l.cxflat_data;
    miss = screen_data->link_l.miss;
    for (; miss; miss--) {
	cxflat_data->type = cflat3;

	nodetype_data->code = cflat3;
	nodetype_data->name = cxflat_data->name;
	nodetype_data->size = cxflat_data->size;
	nodetype_data->flags = X1f4_LX_LINK_ACCESS;

	nodetype_data->copy = x1f4_copy_lxflat;
	nodetype_data->free = x1f4_free_lxflat;
	nodetype_data->lead = x1f4_lead_lxflat;
	nodetype_data->move = NULL;
	nodetype_data->node = x1f4_node_lxflat;
#if 0
	nodetype_data->post = NULL;
#endif				/* 0 */
	nodetype_data->push = x1f4_push_lxflat;
	nodetype_data->slip = x1f4_slip_lxflat;

	nodetype_data++;

	cxflat_data++;

	cflat3++;
    }

    return 0;
}
