/*
 * lxflat-a.c.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxflat-inter.h>
#include <lxflat-types.h>

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxflat_side_flat(void *subtext, void *data)
{
    int status = 0;
    struct dxflat_type *dxflat_data;

    dxflat_data = data;
    /*
     * dxflat_data may well be null... - test may not be removed.
     */
    if (dxflat_data) {
	int (*call) (void *, void *), excess;

	call = ((struct lxflat_type *) subtext)->link_h.call;
	if (call) {
	    status = call
		(((struct lxflat_type *) subtext)->link_h.text, dxflat_data);
	}

	excess = ((struct lxflat_type *) subtext)->link_m.free
	    (((struct lxflat_type *) subtext)->link_m.data, dxflat_data);
	if (excess) {
	    excess = _libx1f4i0_lxflat_stat_free(subtext);
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
