/*
 * lxfile-s.l.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1.h>
#include <e4.h>
#include <file.h>
#include <lxdata.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>
#include <trans.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxfile_l_sequent(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxfile_type *dxfile_data;
	struct lxfile_type *lxfile_data;
	void *file;

	dxfile_data = I_FILE(input[0]);

	lxfile_data = context;

	file = dxfile_data->file;
	if (file) {
	    struct trans_type trans;
	    struct x1f4_dxdata_type *dxdata_data;
	    unsigned size;
	    void *data;

	    if (dxfile_data->mode != READ_CLASS) {
		status = _libx1f4i0_lxfile_stat_node(lxfile_data);
		if (1) {
		    break;
		}
	    }

	    x1f4_hold_lxdata(lxfile_data->link_l.data, (void *) &trans);

	    dxdata_data = I_DATA(input[1]);

	    if (dxdata_data->string != x1f4_c1_empty_string) {
		status = trans.free(trans.data, dxdata_data->string);
		if (status) {
		    status = _libx1f4i0_lxfile_stat_free(lxfile_data);
		} else {
		    dxdata_data->length = 0;
		    dxdata_data->string = (char *) x1f4_c1_empty_string;
		}
	    }

	    data = (char *) x1f4_c1_empty_string;

	    status = _libx1f4i0_line_ifile(file, &data, &size, &trans);
	    if (status) {
		if (status == FILE_OVER_CLASS) {
		    status = 0;

		    l_MODE(-1, output);
		} else {
		    status = _libx1f4i0_lxfile_stat_file(lxfile_data, status);
		}
	    } else {
		l_MODE(size, output);

		dxdata_data->length = size;
		dxdata_data->string = data;
	    }
	} else {
	    status = _libx1f4i0_lxfile_stat_null(context);
	}
    } while (0);

    return status;
}
