/*
 * lxfile-p.s.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_FILE(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lock_exfile(file) \
    (file)

int
_libx1f4i0_lxfile_s_pending(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxfile_type *dxfile_data, *dxfile_text;
	unsigned call;

	dxfile_data = I_FILE(input[0]);
	dxfile_text = I_FILE(input[1]);

	lock_exfile(dxfile_text)->call++;

	call = dxfile_data->call;
	call--;
	if (call) {
	    dxfile_data->call = call;

	    status = 0;
	} else {
	    status = _libx1f4i0_lxfile_side_file
		(context, dxfile_data);
	    if (status) {
		lock_exfile(dxfile_text)->call--;
		_libx1f4i0_lxfile_link_file(context, input[0]);
		if (1) {
		    break;
		}
	    } else {
	    }
	}

	l_FILE(dxfile_text, input[0]);
	l_FILE(dxfile_text, output);
    } while (0);

    return status;
}
