/*
 * lxfile-p.l.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1.h>
#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>
#include <trans.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_TEXT(e, output) \
    {									      \
	const X1f4_E4_C_TEXT *l;					      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxfile_l_pending(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxfile_type *dxfile_data;
	struct lxfile_type *lxfile_data;
	void *file;

	dxfile_data = I_FILE(input[0]);

	lxfile_data = context;

	file = dxfile_data->file;
	if (file) {
	    X1f4_E4_C_TEXT line;
#if __TRANS_FILE_LX_DEFINITION__
#else
	    struct trans_type trans;
#endif				/* __TRANS_FILE_LX_DEFINITION__ */
	    unsigned size;
	    void *data;

	    if (dxfile_data->mode != READ_CLASS) {
		status = _libx1f4i0_lxfile_stat_node(lxfile_data);
		if (1) {
		    break;
		}
	    }

	    line = I_TEXT(input[1]);
	    if (line == x1f4_c1_empty_string) {
	    } else {
		status = lxfile_data->link_m.free
		    (lxfile_data->link_m.data, line);
		if (status) {
		    status = _libx1f4i0_lxfile_stat_free(lxfile_data);

		    break;
		} else {
		    l_TEXT(x1f4_c1_empty_string, input[1]);
		}
	    }

#if __TRANS_FILE_LX_DEFINITION__
#else
	    trans.data = lxfile_data->link_m.data;
	    trans.free = lxfile_data->link_m.free;
	    trans.link = lxfile_data->link_m.link;
	    trans.mode = lxfile_data->link_m.mode;
#endif				/* __TRANS_FILE_LX_DEFINITION__ */

#if __TRANS_FILE_LX_DEFINITION__
	    status = _libx1f4i0_lead_ifile
		(file, &data, &size, &lxfile_data->link_m);
#else
	    status = _libx1f4i0_lead_ifile(file, &data, &size, &trans);
#endif				/* __TRANS_FILE_LX_DEFINITION__ */
	    if (status) {
		if (status == FILE_OVER_CLASS) {
		    status = 0;

		    l_MODE(-1, output);
		} else {
		    status = _libx1f4i0_lxfile_stat_file(lxfile_data, status);
		}
	    } else {
		l_MODE(size, output);
		l_TEXT(data, input[1]);
	    }
	} else {
	    status = _libx1f4i0_lxfile_stat_null(context);
	}
    } while (0);

    return status;
}
