/*
 * lxfile-p.a.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))

extern const struct exfile_type _libx1f4_lxfile_i_file;

int
_libx1f4i0_lxfile_a_pending(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxfile_type *dxfile_data;
	struct lxfile_type *lxfile_data;
	unsigned size;
	void *file;

	dxfile_data = I_FILE(input[0]);

	lxfile_data = context;

	if (dxfile_data->file) {
	    status = x1f4_lose_dxfile(lxfile_data, dxfile_data);
	    if (status) {
		break;
	    }
	}

	_libx1f4i0_size_ifile(&size);

	status = lxfile_data->link_m.link
	    (lxfile_data->link_m.data, &file, size);
	if (status) {
	    status = _libx1f4i0_lxfile_stat_link(lxfile_data);
	} else {
	    status = _libx1f4i0_land_ifile
		(file, I_DATA(input[1]), lxfile_data->link_l.data);
	    if (status) {
		status = _libx1f4i0_lxfile_stat_file(lxfile_data, status);

		lxfile_data->link_m.free(lxfile_data->link_m.data, file);
	    } else {
		dxfile_data->file = file;

		dxfile_data->mode = READ_CLASS;

		dxfile_data->socket = &_libx1f4_lxfile_i_file;
	    }
	}
    } while (0);

    return status;
}
