/*
 * lxfile-l.s.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define exfile(file) \
    ((struct exfile_type *) (file)->socket)

int
_libx1f4i0_lxfile_s_logique(void *context, void *output, void **input)
{
    int status;
    struct dxfile_type *dxfile_data;
    void *file;

    dxfile_data = I_FILE(input[0]);

    file = dxfile_data->file;
    if (file) {
	status = exfile(dxfile_data)->seek
	    (file, I_MODE(input[1]), I_MODE(input[2]));
	if (status) {
	    status = _libx1f4i0_lxfile_stat_file(context, status);
	}
    } else {
	status = _libx1f4i0_lxfile_stat_miss(context);
    }

    return status;
}
