/*
 * lxfile-l.o.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fcntl.h>
#include <stddef.h>

#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#if O_RDWR
#else
# error 0 defined O_RDWR
#endif				/* O_RDONLY */

#if O_RDONLY
#elif O_WRONLY
#else
# error 0 defined O_RDONLY and O_WRONLY
#endif				/* O_RDONLY */

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_libx1f4i0_lxfile_o_logique(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE bits;
	struct dxfile_type *dxfile_data;
	struct lxfile_type *lxfile_data;

	dxfile_data = I_FILE(input[0]);

	lxfile_data = context;

	if (dxfile_data->file) {
	    status = x1f4_lose_dxfile(lxfile_data, dxfile_data);
	    if (status) {
		break;
	    }
	}

	bits = I_MODE(input[2]);

	if (bits & O_RDWR) {
	    status =
		_libx1f4i0_lxfile_stat_pipe(lxfile_data, I_TEXT(input[1]));

	    break;
	} else {
#if O_RDONLY
	    if (bits & O_RDONLY) {
# if O_WRONLY
		if (bits & O_WRONLY) {
		    status = _libx1f4i0_lxfile_stat_else
			(lxfile_data, I_TEXT(input[1]));

		    break;
		} else {
# endif				/* O_WRONLY */
		    status = _libx1f4i0_lxfile_pull_file
			(lxfile_data, dxfile_data, bits, input);
# if O_WRONLY
		}
# endif				/* O_WRONLY */
	    } else {
#endif				/* O_RDONLY */
#if O_WRONLY
		if (bits & O_WRONLY) {
#endif				/* O_WRONLY */
		    status = _libx1f4i0_lxfile_puSh_file
			(lxfile_data, dxfile_data, bits, input);
#if O_WRONLY
		} else {
# if O_RDONLY
		    status = _libx1f4i0_lxfile_stat_none
			(lxfile_data, I_TEXT(input[1]));
# else
		    status = _libx1f4i0_lxfile_pull_file
			(lxfile_data, dxfile_data, bits, input);
# endif				/* O_RDONLY */
		}
#endif				/* O_WRONLY */
#if O_RDONLY
	    }
#endif				/* O_RDONLY */
	}
    } while (0);

    return status;
}
