/*
 * lxfile-e.v.c
 * Copyright (C) 2008-2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

extern const struct exfile_type _libx1f4_lxfile_o_file;

int
x1f4_posh_dxfile(struct lxfile_type *lxfile_data,
		 struct dxfile_type *dxfile_data, int fd)
{
    int status;
    unsigned size;
    void *file;

    _libx1f4i0_size_ofile(&size);

    status = lxfile_data->link_m.link(lxfile_data->link_m.data, &file, size);
    if (status) {
	_libx1f4i0_lxfile_stat_link(lxfile_data);
    } else {
	_libx1f4i0_fset_ofile(file, fd);

	dxfile_data->file = file;

	dxfile_data->mode = PUSH_CLASS;

	dxfile_data->socket = &_libx1f4_lxfile_o_file;

	if (lxfile_data->link_i.bits & SETCLOSE_LINK) {
	    status = _libx1f4i0_fine_ofile(file);
	    if (status) {
		_libx1f4i0_lxfile_stat_fine(lxfile_data, "unnamed");
	    }
	}
    }

    return status;
}
