/*
 * lxfile-e.g.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fcntl.h>
#include <stddef.h>

#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

extern const struct exfile_type _libx1f4_lxfile_o_file;

int
_libx1f4i0_lxfile_puSh_file(void *lxfile, void *dxfile, unsigned bits,
			    void **input)
{
    int status;
    struct dxfile_type *dxfile_data;
    struct lxfile_type *lxfile_data;

    lxfile_data = lxfile;

    dxfile_data = dxfile;

    if (0) {
    } else {
	unsigned size;
	void *file;

	_libx1f4i0_size_ofile(&size);

	status = lxfile_data->link_m.link
	    (lxfile_data->link_m.data, &file, size);
	if (status) {
	    status = _libx1f4i0_lxfile_stat_link(lxfile_data);
	} else {
	    status = _libx1f4i0_open_ofile
		(file, I_TEXT(input[1]), bits, I_MODE(input[3]));
	    if (status) {
		status = _libx1f4i0_lxfile_stat_open
		    (lxfile_data, I_TEXT(input[1]));

		lxfile_data->link_m.free(lxfile_data->link_m.data, file);
	    } else {
		dxfile_data->file = file;

		dxfile_data->mode = PUSH_CLASS;

		dxfile_data->socket = &_libx1f4_lxfile_o_file;

		if (lxfile_data->link_i.bits & SETCLOSE_LINK) {
		    status = _libx1f4i0_fine_ofile(file);
		    if (status) {
			status = _libx1f4i0_lxfile_stat_fine
			    (lxfile_data, I_TEXT(input[1]));
		    }
		}
	    }
	}
    }

    return status;
}
