/*
 * lxfile-d.p.c
 * Copyright (C) 2008-2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <file.h>
#include <lxdata.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxfile_p_derived(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxfile_type *dxfile_data;
	void *file;

	dxfile_data = I_FILE(input[0]);

	file = dxfile_data->file;
	if (file) {
	    struct x1f4_dxdata_type *dxdata_data;

	    if (dxfile_data->mode != PUSH_CLASS) {
		status = _libx1f4i0_lxfile_stat_line(context);
		if (1) {
		    break;
		}
	    }

	    dxdata_data = I_DATA(input[1]);

	    status = _libx1f4i0_push_ofile
		(file, dxdata_data->string, dxdata_data->length);
	    if (status) {
		status = _libx1f4i0_lxfile_stat_file(context, status);
	    }
	} else {
	    status = _libx1f4i0_lxfile_stat_love(context);
	}
    } while (0);

    return status;
}
