/*
 * lxfile-d.l.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1.h>
#include <e4.h>
#include <exerrors.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>
#include <trans.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern int x1f4_warp_lxlist
    (void *, void *, unsigned *, unsigned, int *, void *,
     int (*) (void *, void *, unsigned *, unsigned, int (*) (void *, void *),
	      struct trans_type *));

int
_libx1f4i0_lxfile_l_derived(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxfile_type *dxfile_data;
	struct lxfile_type *lxfile_data;
	void *file;

	dxfile_data = I_FILE(input[0]);

	lxfile_data = context;

	file = dxfile_data->file;
	if (file) {
	    int delete;
	    unsigned size;

	    if (dxfile_data->mode != READ_CLASS) {
		status = _libx1f4i0_lxfile_stat_node(lxfile_data);
		if (1) {
		    break;
		}
	    }

	    status = x1f4_warp_lxlist
		(lxfile_data->link_l.list, I_LIST(input[1]),
		 &size, I_MODE(input[2]), &delete, file,
		 _libx1f4i0_list_ifile);
	    if (status) {
	    } else {
		if (delete) {
		    if (delete == FILE_OVER_CLASS) {
			l_MODE(-1, output);
		    } else {
			status = _libx1f4i0_lxfile_stat_file
			    (lxfile_data, delete);
		    }
		} else {
		    l_MODE(size, output);
		}
	    }
	} else {
	    status = _libx1f4i0_lxfile_stat_null(lxfile_data);
	}
    } while (0);

    return status;
}
