/*
 * lxfile-a.y.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxfile-inter.h>
#include <nt.h>

int
x1f4_type_lxfile(struct x1f4_nodetype_type *nodetype_data, int cfile3)
{
    nodetype_data->code = cfile3;
    nodetype_data->name = "file";
    nodetype_data->size = 4;
    nodetype_data->flags = X1f4_LX_LINK_ACCESS;

    nodetype_data->copy = x1f4_copy_lxfile;
    nodetype_data->free = x1f4_free_lxfile;
    nodetype_data->lead = x1f4_lead_lxfile;
    nodetype_data->move = NULL;
    nodetype_data->node = x1f4_node_lxfile;
#if 0
    nodetype_data->post = NULL;
#endif				/* 0 */
    nodetype_data->push = x1f4_push_lxfile;
    nodetype_data->slip = x1f4_slip_lxfile;

    return 0;
}
