/*
 * lxfile-a.0.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

/*
 * TODO
 *
 *.improve on _data_ readers by not freeing the existing buffer.  it can be
 * achieved by messing with the memory allocator.
 *
 */

#define MAKE_SINGLE(a, b)		a

#define FFLAGS_KT			X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK
#define FFLAGS_KPT \
    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK

#define fb_size()			1

#define screen(screen) \
    ((struct screen_type *) (screen))

static int init_file(struct lxfile_type *, unsigned,
		     const struct screen_type *);
static int line_file(struct lxfile_type *, unsigned,
		     const struct screen_type *);
static int line_text(struct lxfile_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_file(struct lxfile_type *, unsigned,
		     const struct screen_type *);

static void line_afix(u_case_args_____0);
static void line_amap(u_case_args_____0);
static void line_bfix(u_case_args_____0);
static void line_bmap(u_case_args_____0);
static void line_cfix(u_case_args_____0);
static void line_cmap(u_case_args_____0);
static void line_cway(u_case_args_____0);
static void line_emap(u_case_args_____0);
static void line_ffar(u_case_args_____0);
static void line_ffix(u_case_args_____0);
static void line_fway(u_case_args_____0);
static void line_hmap(u_case_args_____0);
static void line_lfar(u_case_args_____0);
static void line_lfix(u_case_args_____0);
static void line_lmap(u_case_args_____0);
static void line_lset(u_case_args_____0);
static void line_lway(u_case_args_____0);
static void line_mway(u_case_args_____0);
static void line_nmap(u_case_args_____0);
static void line_ofix(u_case_args_____0);
static void line_pfix(u_case_args_____0);
static void line_pmap(u_case_args_____0);
static void line_pset(u_case_args_____0);
static void line_pway(u_case_args_____0);
static void line_rmap(u_case_args_____0);
static void line_sfix(u_case_args_____0);
static void line_smap(u_case_args_____0);
static void line_srun(u_case_args_____0);
static void line_sset(u_case_args_____0);
static void line_sway(u_case_args_____0);
static void line_tfix(u_case_args_____0);
static void line_wmap(u_case_args_____0);

static const char ff_setf[] = "f_set", *const side_f[] = {
/* *INDENT-OFF* */
    ff_setf
/* *INDENT-ON* */
};
static const struct line_type beta_line[] = {
/* *INDENT-OFF* */
#define l_b_affix_count			2
    {	{	"f_b_affix",
		_libx1f4i0_lxfile_a_pending,	X1f4_E4_VOID,
		NULL,				l_b_affix_count,
		FFLAGS_KT,			9		},
	line_amap,							},
#define l_b_affix_reach			l_b_affix_count
#define l_b_bind_count			2
    {	{	"f_b_bind",
		_libx1f4i0_lxfile_b_pending,	X1f4_E4_VOID,
		NULL,				l_b_bind_count,
		FFLAGS_KT,			8		},
	line_bmap,							},
#define l_b_bind_reach			(l_b_affix_reach + l_b_bind_count)
#define l_b_fast_count			3
    {	{	"f_b_fast",
		_libx1f4i0_lxfile_f_sequent,	X1f4_E4_MODE,
		NULL,				l_b_fast_count,
		FFLAGS_KT,			8		},
	line_ffar,							},
#define l_b_fast_reach			(l_b_bind_reach + l_b_fast_count)
#define l_b_line_count			2
    {	{	"f_b_line",
		_libx1f4i0_lxfile_l_sequent,	X1f4_E4_MODE,
		NULL,				l_b_line_count,
		FFLAGS_KT,			8		},
	line_lfar,							},
#define l_b_line_reach			(l_b_fast_reach + l_b_line_count)
#define l_b_post_count			2
    {	{	"f_b_post",
		_libx1f4i0_lxfile_p_derived,	X1f4_E4_VOID,
		NULL,				l_b_post_count,
		FFLAGS_KT,			8		},
	line_pway,							},
#define l_b_post_reach			(l_b_line_reach + l_b_post_count)
#define l_b_read_count			3
    {	{	"f_b_read",
		_libx1f4i0_lxfile_r_pending,	X1f4_E4_MODE,
		NULL,				l_b_read_count,
		FFLAGS_KT,			8		},
	line_rmap,							}
#define l_b_read_reach			(l_b_post_reach + l_b_read_count)
/* *INDENT-ON* */
#define beta_line_count			l_b_read_reach
}, ever_line[] = {
/* *INDENT-OFF* */
#define l_set_count			2
    {	{	ff_setf,
		_libx1f4i0_lxfile_s_pending,	0,
		NULL,				l_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_smap,							}
#define l_set_reach			(0 + (l_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			l_set_reach
}, list_line[] = {
/* *INDENT-OFF* */
#define l_list_count			3
    {	{	"f_list",
		_libx1f4i0_lxfile_l_derived,	X1f4_E4_MODE,
		NULL,				l_list_count,
		FFLAGS_KT,			6		},
	line_lway,							}
#define l_list_reach			(0 + l_list_count)
/* *INDENT-ON* */
#define list_line_count			l_list_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define l_affix_count			2
    {	{	"f_affix",
		_libx1f4i0_lxfile_a_logique,	X1f4_E4_VOID,
		NULL,				l_affix_count,
		FFLAGS_KT,			7		},
	line_afix,							},
#define l_affix_reach			l_affix_count
#define l_bind_count			2
    {	{	"f_bind",
		_libx1f4i0_lxfile_b_logique,	X1f4_E4_VOID,
		NULL,				l_bind_count,
		FFLAGS_KT,			6		},
	line_bfix,							},
#define l_bind_reach			(l_affix_reach + l_bind_count)
#define l_case_count			2
    {	{	"f_case",
		_libx1f4i0_lxfile_c_pending,	X1f4_E4_MODE,
		NULL,				l_case_count,
		FFLAGS_KPT,			6		},
	line_cmap,							},
#define l_case_reach			(l_bind_reach + (l_case_count << 1))
#define l_close_count			1
    {	{	"f_close",
		_libx1f4i0_lxfile_c_logique,	X1f4_E4_VOID,
		NULL,				l_close_count,
		FFLAGS_KT,			7		},
	line_cfix,							},
#define l_close_reach			(l_case_reach + l_close_count)
#define l_create_count			3
    {	{	"f_create",
		_libx1f4i0_lxfile_c_derived,	X1f4_E4_VOID,
		NULL,				l_create_count,
		FFLAGS_KT,			8		},
	line_cway,							},
#define l_create_reach			(l_close_reach + l_create_count)
#define l_ever_count			3
    {	{	"f_ever",
		_libx1f4i0_lxfile_e_pending,	X1f4_E4_MODE,
		NULL,				l_ever_count,
		FFLAGS_KPT,			6		},
	line_emap,							},
#define l_ever_reach			(l_create_reach + (l_ever_count << 1))
#define l_fast_count			3
    {	{	"f_fast",
		_libx1f4i0_lxfile_f_derived,	X1f4_E4_MODE,
		NULL,				l_fast_count,
		FFLAGS_KPT,			6		},
	line_fway,							},
#define l_fast_reach			(l_ever_reach + (l_fast_count << 1))
#define l_flush_count			1
    {	{	"f_flush",
		_libx1f4i0_lxfile_f_logique,	X1f4_E4_VOID,
		NULL,				l_flush_count,
		FFLAGS_KT,			7		},
	line_ffix,							},
#define l_flush_reach			(l_fast_reach + l_flush_count)
#define l_head_count			2
    {	{	"f_head",
		_libx1f4i0_lxfile_h_pending,	X1f4_E4_MODE,
		NULL,				l_head_count,
		FFLAGS_KPT,			6		},
	line_hmap,							},
#define l_head_reach			(l_flush_reach + (l_head_count << 1))
#define l_lead_count			2
    {	{	"f_lead",
		_libx1f4i0_lxfile_l_pending,	X1f4_E4_MODE,
		NULL,				l_lead_count,
		FFLAGS_KPT,			6		},
	line_lmap,							},
#define l_lead_reach			(l_head_reach + (l_lead_count << 1))
#define l_line_count			2
    {	{	"f_line",
		_libx1f4i0_lxfile_l_logique,	X1f4_E4_MODE,
		NULL,				l_line_count,
		FFLAGS_KPT,			6		},
	line_lfix,							},
#define l_line_reach			(l_lead_reach + (l_line_count << 1))
#define l_look_count			2
    {	{	"f_look",
		_libx1f4i0_lxfile_l_forward,	X1f4_E4_MODE,
		NULL,				l_look_count,
		FFLAGS_KT,			6		},
	line_lset,							},
#define l_look_reach			(l_line_reach + l_look_count)
#define l_mind_count			3
    {	{	"f_mind",
		_libx1f4i0_lxfile_m_derived,	X1f4_E4_MODE,
		NULL,				l_mind_count,
		FFLAGS_KPT,			6		},
	line_mway,							},
#define l_mind_reach			(l_look_reach + (l_mind_count << 1))
#define l_near_count			3
    {	{	"f_near",
		_libx1f4i0_lxfile_n_pending,	X1f4_E4_MODE,
		NULL,				l_near_count,
		FFLAGS_KPT,			6		},
	line_nmap,							},
#define l_near_reach			(l_mind_reach + (l_near_count << 1))
#define l_open_count			4
    {	{	"f_open",
		_libx1f4i0_lxfile_o_logique,	X1f4_E4_VOID,
		NULL,				l_open_count,
		FFLAGS_KT,			6		},
	line_ofix,							},
#define l_open_reach			(l_near_reach + l_open_count)
#define l_peek_count			1
    {	{	"f_peek",
		_libx1f4i0_lxfile_p_logique,	X1f4_E4_MODE,
		NULL,				l_peek_count,
		FFLAGS_KT,			6		},
	line_pfix,							},
#define l_peek_reach			(l_open_reach + l_peek_count)
#define l_peep_count			2
    {	{	"f_peep",
		_libx1f4i0_lxfile_p_pending,	X1f4_E4_MODE,
		NULL,				l_peep_count,
		FFLAGS_KT,			6		},
	line_pmap,							},
#define l_peep_reach			(l_peek_reach + l_peep_count)
#define l_pick_count			1
    {	{	"f_pick",
		_libx1f4i0_lxfile_p_forward,	X1f4_E4_MODE,
		NULL,				l_pick_count,
		FFLAGS_KT,			6		},
	line_pset,							},
#define l_pick_reach			(l_peep_reach + l_pick_count)
#define l_seek_count			3
    {	{	"f_seek",
		_libx1f4i0_lxfile_s_logique,	X1f4_E4_VOID,
		NULL,				l_seek_count,
		FFLAGS_KT,			6		},
	line_sfix,							},
#define l_seek_reach			(l_pick_reach + l_seek_count)
#define l_side_count			2
    {	{	"f_side",
		_libx1f4i0_lxfile_s_derived,	X1f4_E4_MODE,
		NULL,				l_side_count,
		FFLAGS_KT,			6		},
	line_sway,							},
#define l_side_reach			(l_seek_reach + l_side_count)
#define l_skip_count			2
    {	{	"f_skip",
		_libx1f4i0_lxfile_s_forward,	X1f4_E4_MODE,
		NULL,				l_skip_count,
		FFLAGS_KT,			6		},
	line_sset,							},
#define l_skip_reach			(l_side_reach + l_skip_count)
#define l_slip_count			1
    {	{	"f_slip",
		_libx1f4i0_lxfile_s_nearest,	X1f4_E4_MODE,
		NULL,				l_slip_count,
		FFLAGS_KT,			6		},
	line_srun,							},
#define l_slip_reach			(l_skip_reach + l_slip_count)
#define l_tell_count			1
    {	{	"f_tell",
		_libx1f4i0_lxfile_t_logique,	X1f4_E4_MODE,
		NULL,				l_tell_count,
		FFLAGS_KT,			6		},
	line_tfix,							},
#define l_tell_reach			(l_slip_reach + l_tell_count)
#define l_word_count			2
    {	{	"f_word",
		_libx1f4i0_lxfile_w_pending,	X1f4_E4_MODE,
		NULL,				l_word_count,
		FFLAGS_KPT,			6		},
	line_wmap,							}
#define l_word_reach			(l_tell_reach + (l_word_count << 1))
/* *INDENT-ON* */
#define slip_line_count			l_word_reach
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_file(struct lxfile_type *lxfile_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & CODELINK_LINK) {
	lxfile_data->link_w.data = screen_data->link_w.data;
	lxfile_data->link_w.free = screen_data->link_w.free;
	lxfile_data->link_w.link = screen_data->link_w.link;
	lxfile_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxfile_data->link_w.data = NULL;
	lxfile_data->link_w.free = _x1f4_e4_free_data;
	lxfile_data->link_w.link = _x1f4_e4_link_data;
	lxfile_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & RESOURCE_LINK) {
	lxfile_data->link_m.data = screen_data->link_m.data;
	lxfile_data->link_m.free = screen_data->link_m.free;
	lxfile_data->link_m.link = screen_data->link_m.link;
	lxfile_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxfile_data->link_m.data = NULL;
	lxfile_data->link_m.free = _x1f4_e4_free_data;
	lxfile_data->link_m.link = _x1f4_e4_link_data;
	lxfile_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxfile_data->link_e.data = screen_data->link_e.data;
	lxfile_data->link_e.line = screen_data->link_e.line;
	lxfile_data->link_e.post = screen_data->link_e.post;
	lxfile_data->link_e.push = screen_data->link_e.push;
    } else {
	lxfile_data->link_e.data = NULL;
	lxfile_data->link_e.line = NULL;
	lxfile_data->link_e.post = NULL;
	lxfile_data->link_e.push = NULL;
    }

    if (1) {
	lxfile_data->link_i.bits = bits;
    }

    status = link_file(lxfile_data, bits, screen_data);

    return status;
}


static int
line_file(struct lxfile_type *lxfile_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxfile_data->link_t.datatype[0].context = lxfile_data;

    lxfile_data->link_t.datatype[0].flat = _libx1f4i0_lxfile_flat_file;
    lxfile_data->link_t.datatype[0].lead = _libx1f4i0_lxfile_lead_file;
    lxfile_data->link_t.datatype[0].line = _libx1f4i0_lxfile_line_file;
    lxfile_data->link_t.datatype[0].link = _libx1f4i0_lxfile_link_file;
    lxfile_data->link_t.datatype[0].name = "file";
    lxfile_data->link_t.datatype[0].shut = _libx1f4i0_lxfile_shut_file;
    lxfile_data->link_t.datatype[0].slip = _libx1f4i0_lxfile_slip_file;
    lxfile_data->link_t.datatype[0].size = 4;
    lxfile_data->link_t.datatype[0].type = screen_data->link_l.type;

    lxfile_data->link_t.datatype[1].context = NULL;

    lxfile_data->link_t.datatype[1].flat = NULL;
    lxfile_data->link_t.datatype[1].lead = NULL;
    lxfile_data->link_t.datatype[1].line = NULL;
    lxfile_data->link_t.datatype[1].link = NULL;
    lxfile_data->link_t.datatype[1].name = NULL;
    lxfile_data->link_t.datatype[1].shut = NULL;
    lxfile_data->link_t.datatype[1].slip = NULL;
    lxfile_data->link_t.datatype[1].size = 0;
    lxfile_data->link_t.datatype[1].type = 0;

    return 0;
}


static int
line_text(struct lxfile_type *lxfile_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxfile_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & DATALINK_LINK) {
	_libx1f4i0_lxcall_side_line
	    (lxfile_data, bits, screen_data, linetext_data, args,
	     sizeof(beta_line) / sizeof(struct line_type), beta_line);
	linetext_data += sizeof(beta_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxfile_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (bits & LISTLINK_LINK) {
	_libx1f4i0_lxcall_side_line
	    (lxfile_data, bits, screen_data, linetext_data, args,
	     sizeof(list_line) / sizeof(struct line_type), list_line);
	linetext_data += sizeof(list_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_file(struct lxfile_type *lxfile_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_count, line_count;
    void *data;

    args_count = 0;
    line_count = 1;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & DATALINK_LINK) {
	args_count += beta_line_count;
	line_count += sizeof(beta_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (bits & LISTLINK_LINK) {
	args_count += list_line_count;
	line_count += sizeof(list_line) / sizeof(struct line_type);
    }

    status = lxfile_data->link_w.link
	(lxfile_data->link_w.data, &data,
	 args_count * sizeof(int)
	 + line_count * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side;

	side = (struct x1f4_linetext_type *) data + line_count;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;

	lxfile_data->link_f.data = data;
	lxfile_data->link_f.side = side;

	line_text(lxfile_data, bits, screen_data, data, &args, &dana);
	_libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	line_file(lxfile_data, bits, screen_data);
    }

    return status;
}


static void
line_afix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_amap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_f.type;

    *args = line;
}


static void
line_bfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_bmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_f.type;

    *args = line;
}


static void
line_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_cway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_emap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_ffar(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = screen(screen)->link_f.type;

    *args = line;
}


static void
line_ffix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_fway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_hmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_lfar(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_f.type;

    *args = line;
}


static void
line_lfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_lmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_lset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_lway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_i.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_mway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_nmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_ofix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_pfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_pmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_pset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_pway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_f.type;

    *args = line;
}


static void
line_rmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_f.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_sfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_smap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_srun(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_sway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_tfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_wmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


int
x1f4_init_lxfile(void **lxfile, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *file, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &file, sizeof(struct lxfile_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_file(file, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, file);
	    } else {
		_x1f4_e4_free_data(text, file);
	    }
	} else {
	    *lxfile = file;
	}
    }

    return status;
}
