/*
 * lxdecq-t.e.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <f_list.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxdecq_v_class_t(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    dxlist_data = I_LIST(input[1]);
    if (0) {
    } else {
	unsigned size;

	size = dxlist_data->size;
	if (!size) {
	    status = _libx1f4i0_lxdecq_stat_null(lxtext_data->text);
	} else {
	    void *data;

	    status = _libx1f4i0_ever_dllist(dxlist_data->list, &data);
	    if (status) {
		status =
		    _libx1f4i0_lxdecq_stat_list(lxtext_data->text, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != X1f4_E4_TEXT) {
		    status = _libx1f4i0_lxdecq_stat_type
			(lxtext_data->text, size - 1, type,
			 lxtext_data->lxtype.code);
		} else {
		    X1f4_E4_C_TEXT post;

		    post = I_TEXT(byte(data) + 8);

		    status = _libx1f4i0_slip_dllist(dxlist_data->list);
		    if (status) {
			status = _libx1f4i0_lxdecq_stat_list
			    (lxtext_data->text, status);
		    } else {
			dxlist_data->size = size - 1;

			status = lxtext_data->lxtype.push
			    (lxtext_data->lxtype.context,
			     input[0], post, lock_excase(dxlist_data));
			if (status) {
			}
		    }
		}
	    }
	}
    }

    return status;
}
