/*
 * lxdecq-p.s.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <f_list.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxdecq_s_pending(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	unsigned size;

	size = dxlist_data->size;
	if (!size) {
	    status = _libx1f4i0_lxdecq_stat_null(context);
	} else {
	    void *data;

	    status = _libx1f4i0_ever_dllist(dxlist_data->list, &data);
	    if (status) {
		status = _libx1f4i0_lxdecq_stat_list(context, status);
	    } else {
		do {
		    unsigned link;

		    link = byte(data)[4] << 030 | byte(data)[5] << 020
			| byte(data)[6] << 010 | byte(data)[7];
		    if (~link) {
			int (*free) (void *, void *, struct excase_type **,
				     const struct excase_type *);
			struct lxtext_type *lxtext_link;

			lxtext_link =
			    ((struct lxtext_type *)
			     ((struct lxdecq_type *)
			      context)->link_f.text) + link;

			free = lxtext_link->lxtype.free;
			if (free) {
			    status = free
				(lxtext_link->lxtype.context,
				 I_USER(byte(data) + 8), NULL,
				 lock_excase(dxlist_data));
			    if (status) {
				break;
			    }
			}
		    }

		    status = _libx1f4i0_slip_dllist(dxlist_data->list);
		    if (status) {
			status = _libx1f4i0_lxdecq_stat_list
			    (context, status);
		    } else {
			dxlist_data->size = size - 1;
		    }
		} while (0);
	    }
	}
    }

    return status;
}
