/*
 * lxdecq-e.n.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdecq-config.h>

#include <f_list.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <tcvset.h>

#define lxdecq(list) \
    ((struct lxdecq_type *) (list))

int
_libx1f4i0_lxdecq_fine_list(void *subtext, void *dxlist)
{
    int status;
    struct dxlist_type *dxlist_data;

    dxlist_data = dxlist;
    if (0) {
    } else {
	if (0) {
	} else {
	    int (*call) (void *, struct x1f4_nodelink_type *), excess;

	    status = _libx1f4i0_fini_tcvset
		(&lock_exlist(dxlist_data)->pset,
		 &lock_exlist(dxlist_data)->text,
		 (void *) &((struct lxdecq_type *) subtext)->link_m);
	    if (status) {
		status = _libx1f4i0_lxdecq_stat_free(subtext);
	    }

	    call = lxdecq(subtext)->link_r.call;
	    if (call) {
		call(lxdecq(subtext)->link_r.text, lock_excase(dxlist));
	    }

	    excess = _libx1f4i0_flat_dllist(dxlist_data->list);
	    if (excess) {
		excess = _libx1f4i0_lxdecq_stat_list(subtext, excess);
		if (status) {
		} else {
		    status = excess;
		}
	    }

	    excess = ((struct lxdecq_type *) subtext)->link_m.free
		(((struct lxdecq_type *) subtext)->link_m.data,
		 lock_cxlist(dxlist_data));
	    if (excess) {
		excess = _libx1f4i0_lxdecq_stat_free(subtext);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}
