/*
 * lxdecq-e.o.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <exerrors.h>
#include <lxdecq-types.h>
#include <lxlead.h>
#include <nl.h>
#include <tcvset.h>

#define lxdecq(list) \
    ((struct lxdecq_type *) (list))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_move_lxdecq(void *subtext, void *dxlist,
		 const struct x1f4_nodelink_type *excase_miss,
		 const struct x1f4_nodelink_type *excase_push)
{
    int status;

    status = tccase(lock_exlist(dxlist)->text)->mode
	(&lock_exlist(dxlist)->pset, excase_miss, excase_push);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	int (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);

	miss = lxdecq(subtext)->link_r.miss;
	if (miss) {
	    status = miss
		(lxdecq(subtext)->link_r.text, NULL,
		 lock_excase(dxlist));
	} else {
	    status = x1f4_mind_lxlead(NULL, dxlist);
	}
    }

    return status;
}
