/*
 * lxdecq-e.e.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <lxlead.h>
#include <tcvset.h>

#define lxdecq(list) \
    ((struct lxdecq_type *) (list))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_pick_lxdecq(void *subtext, void *dxlist, struct excase_type **excase,
		 const struct excase_type *excase_data)
{
    int status;
    unsigned call;

    call = lock_exlist(dxlist)->call;

    if (call) {
	call--;
	if (call) {
	    status = tccase(lock_exlist(dxlist)->text)->miss
		(&lock_exlist(dxlist)->pset, &lock_exlist(dxlist)->text,
		 excase_data, (void *) &lxdecq(subtext)->link_m);
	    if (status) {
		status = X1f4_EX_CRITICAL;
	    } else {
		int (*fine) (void *, struct x1f4_nodelink_type **,
			     struct x1f4_nodelink_type *);

		lock_exlist(dxlist)->call = call;

		fine = lxdecq(subtext)->link_r.fine;
		if (fine) {
		    status = fine
			(lxdecq(subtext)->link_r.text, excase,
			 lock_excase(dxlist));
		} else {
		    x1f4_side_lxlead(excase, dxlist);
		}
	    }
	} else {
	    status = 0;
	    if (lock_excase(dxlist)->slip) {
	    } else {
		lock_exlist(dxlist)->call = 0;
		lock_excase(dxlist)->slip = *excase;
		*excase = lock_excase(dxlist);
	    }
	}
    } else {
	status = 0;
    }

    return status;
}
