/*
 * lxdecq-a.x.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <exerrors.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <tcvset.h>

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_push_lxdecq(void *subtext, void **copy, void *list,
		 const struct excase_type *excase_data)
{
    int status;

    status = tccase(lock_exlist(list)->text)->miss
	(&lock_exlist(list)->pset, &lock_exlist(list)->text, excase_data,
	 (void *) &((struct lxdecq_type *) subtext)->link_m);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	status = _libx1f4i0_lxdecq_side_list(subtext, *copy);
	if (status) {
	    _libx1f4i0_lxdecq_link_list(subtext, copy);
	} else {
	    *copy = (void *) list;
	}
    }

    return status;
}
