/*
 * lxdecq-a.t.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <f_list.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <lxfset.h>
#include <lxlead.h>

#define dxlist(list) \
    ((struct dxlist_type *) (list))
#define lxdecq(list) \
    ((struct lxdecq_type *) (list))

int
_libx1f4i0_lxdecq_late_list(void *subtext, void *late, void *copy,
			    const void *list)
{
    int status;
    struct lxdecq_type *lxdecq_data;

    lxdecq_data = subtext;

    if (1) {
	void *becca[6];

	becca[0] = subtext;
	becca[2] = late;

	status = x1f4_init_lxfset(becca + 3);
	if (status) {
	    status = _libx1f4i0_lxdecq_stat_link(lxdecq_data);
	} else {
	    int excess;
	    void **node, *record;

	    status = x1f4_post_lxfset(becca[3], &list, &record);
	    if (status) {
		status = _libx1f4i0_lxdecq_stat_link(lxdecq_data);
	    } else {
		node = record;

		node[0] = (void *) list;
		node[1] = late;

		becca[4] = &lxdecq_data->link_m;
		becca[5] = NULL;

		status = _libx1f4i0_line_dllist
		    (dxlist(copy)->list, dxlist(list)->list,
		     _libx1f4i0_lxdecq_copy_link, _libx1f4i0_lxdecq_free_link,
		     becca);
		if (status) {
		    status = _libx1f4i0_lxdecq_stat_list(lxdecq_data, status);

		    x1f4_lose_lxlead(becca[5], &lxdecq_data->link_m);
		} else {
		    dxlist(copy)->size = dxlist(list)->size;

		    status = x1f4_beta_lxlead
			(becca[3], becca[5], &lxdecq_data->link_m);
		}
	    }

	    excess = x1f4_fini_lxfset(becca + 3);
	    if (excess) {
		excess = _libx1f4i0_lxdecq_stat_free(lxdecq_data);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}
