/*
 * lxdecq-a.e.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <exerrors.h>
#include <f_list.h>
#if !defined HAVE_LIBx1f4i0
# include <integral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define lxdecq(lxdecq) \
    ((struct lxdecq_type *) (lxdecq))

static int make_type(void *, void *, int (*) (void *, const char *, unsigned),
		     unsigned);

static int
make_type(void *lxdecq, void *data,
	  int (*push) (void *, const char *, unsigned), unsigned type)
{
    return x1f4_dump_type
	(data, push, type, lxdecq(lxdecq)->trap_e.eelookup_data);
}


int
_libx1f4i0_lxdecq_stat_call(void *lxdecq, int mode, unsigned found,
			    unsigned expected, int error)
{
    int status;

    if (error == X1f4_DLLIST_CALL_ERROR) {
	status = _libx1f4i0_lxdecq_stat_type(lxdecq, mode, found, expected);
    } else {
	status = _libx1f4i0_lxdecq_stat_list(lxdecq, error);
    }

    return status;
}


#if 0
int
_libx1f4i0_lxdecq_stat_copy(void *lxdecq)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdecq(lxdecq)->link_e.data;

	line = lxdecq(lxdecq)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdecq(lxdecq)->link_e.push;
	if (push) {
	    status = push(data, "cannot copy/link/move list for non self inc"
			  "lusion rules say so", 62);
	    if (status) {
		break;
	    }
	}

	post = lxdecq(lxdecq)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
#endif


int
_libx1f4i0_lxdecq_stat_free(void *lxdecq)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdecq(lxdecq)->link_e.data;

	line = lxdecq(lxdecq)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdecq(lxdecq)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxdecq(lxdecq)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdecq_stat_link(void *lxdecq)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdecq(lxdecq)->link_e.data;

	line = lxdecq(lxdecq)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdecq(lxdecq)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxdecq(lxdecq)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdecq_stat_list(void *lxdecq, int error)
{
    int status;

    if (error == X1f4_DLLIST_FREE_ERROR) {
	status = _libx1f4i0_lxdecq_stat_free(lxdecq);
    } else {
	if (error == X1f4_DLLIST_LINK_ERROR) {
	    status = _libx1f4i0_lxdecq_stat_link(lxdecq);
	} else {
	    if (error == X1f4_DLLIST_MODE_ERROR) {
		status = _libx1f4i0_lxdecq_stat_mode(lxdecq);
	    } else {
		if (error == X1f4_DLLIST_SIZE_ERROR) {
		    status = _libx1f4i0_lxdecq_stat_size(lxdecq);
		} else {
		    status = X1f4_EX_CRITICAL;
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxdecq_stat_mode(void *lxdecq)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdecq(lxdecq)->link_e.data;

	line = lxdecq(lxdecq)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdecq(lxdecq)->link_e.push;
	if (push) {
	    status = push(data, "cannot reallocate memory", 24);
	    if (status) {
		break;
	    }
	}

	post = lxdecq(lxdecq)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdecq_stat_null(void *lxdecq)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdecq(lxdecq)->link_e.data;

	line = lxdecq(lxdecq)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdecq(lxdecq)->link_e.push;
	if (push) {
	    status = push(data, "empty list", 10);
	    if (status) {
		break;
	    }
	}

	post = lxdecq(lxdecq)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdecq_stat_size(void *lxdecq)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdecq(lxdecq)->link_e.data;

	line = lxdecq(lxdecq)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdecq(lxdecq)->link_e.push;
	if (push) {
	    status = push(data, "list not empty", 14);
	    if (status) {
		break;
	    }
	}

	post = lxdecq(lxdecq)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdecq_stat_type(void *lxdecq, int mode, unsigned found,
			    unsigned expected)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdecq(lxdecq)->link_e.data;

	line = lxdecq(lxdecq)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdecq(lxdecq)->link_e.push;
	if (push) {
	    status = push(data, "mismatched type (", 17);
	    if (status) {
		break;
	    } else {
		status = make_type(lxdecq, data, push, found);
		if (status) {
		    break;
		} else {
		    status = push(data, " found, ", 8);
		    if (status) {
			break;
		    } else {
			status = make_type(lxdecq, data, push, expected);
			if (status) {
			    break;
			} else {
			    status = push(data, " expected) for ", 15);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_dintegral
				    (data, push, mode + 1);
				if (status) {
				    break;
				} else {
				    char miss[2];

				    x1f4_extend_ordinal(miss, mode);
				    status = push(data, miss, 2);
				    if (status) {
					break;
				    } else {
					status = push
					    (data, " list element", 13);
					if (status) {
					    break;
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxdecq(lxdecq)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
