/*
 * lxdate-types.h
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxdate_types_H__
#define __LIBx1f4_lxdate_types_H__

#include <lxdate-config.h>

#include <time.h>

#include <dt.h>
#if __TRANS_DATE_LX_DEFINITION__
# include <trans.h>
#endif				/* __TRANS_DATE_LX_DEFINITION__ */

typedef struct dxdate_type {
    time_t time;
    unsigned call, second_f, second_i, second_l;
} dxdate_type;

typedef struct dxtime_type {
    unsigned call, second_a, second_f, second_l;
} dxtime_type;

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxdate_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	void *data, *side;
    } link_f;
#if __TRANS_DATE_LX_DEFINITION__
    struct trans_type link_m;
#else
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
#endif				/* __TRANS_DATE_LX_DEFINITION__ */
    struct {
	struct x1f4_datatype_type datatype[3];
    } link_t;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} lxdate_type;

typedef struct screen_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	int type;
    } link_j;
    struct {
	int type;
    } link_l;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} screen_type;

#endif				/* __LIBx1f4_lxdate_types_H__ */
