/*
 * lxdate-l.n.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <time.h>

#include <sys/time.h>

#include <e4.h>
#include <lxdate-types.h>

#define I_DATE(t)			(*((X1f4_E4_C_USER *) (t)))

#define SECOND_a(v)			((v).tv_sec)
#define SECOND_f(v)			((v).tv_usec)

#define b3(___b)			((___b) & 7)
#define b4(___b)			((___b) & 15)
#define b5(___b)			((___b) & 31)
#define b6(___b)			((___b) & 63)
#define b9(___b)			((___b) & 511)

int
_libx1f4i0_lxdate_n_logique(void *context, void *output, void **input)
{
    struct dxdate_type *dxdate_data;
    struct timeval current_time;
    struct tm *down_time;

    dxdate_data = I_DATE(input[0]);

    gettimeofday(&current_time, NULL);

    dxdate_data->time = SECOND_a(current_time);

    dxdate_data->second_f = SECOND_f(current_time);

    down_time = localtime(&SECOND_a(current_time));

    dxdate_data->second_i = b6(down_time->tm_sec) | b6(down_time->tm_min) << 6
	| b5(down_time->tm_hour) << 12 | b5(down_time->tm_mday) << 17
	| b4(down_time->tm_mon) << 22;
    dxdate_data->second_l = b3(down_time->tm_wday)
	| b9(down_time->tm_yday) << 3 | down_time->tm_year << 12;

    return 0;
}
