/*
 * lxdate-l.a.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <time.h>

#include <e4.h>
#include <lxdate-types.h>

#define I_DATE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TIME(t)			(*((X1f4_E4_C_USER *) (t)))

#define b3(___b)			((___b) & 7)
#define b4(___b)			((___b) & 15)
#define b5(___b)			((___b) & 31)
#define b6(___b)			((___b) & 63)
#define b9(___b)			((___b) & 511)

int
_libx1f4i0_lxdate_a_logique(void *context, void *output, void **input)
{
    struct dxdate_type *dxdate_data;
    struct dxtime_type *dxtime_data;
    struct tm *down_time;
    time_t second_a;
    unsigned second_f;

    dxdate_data = I_DATE(input[0]);

    dxtime_data = I_TIME(input[1]);

    second_a = dxdate_data->time;
    second_f = dxdate_data->second_f;

    if (dxtime_data->second_l & 1 << 17) {
	second_a -= dxtime_data->second_a;

	second_f -= dxtime_data->second_f;
	if ((int) second_f < 0) {
	    second_a--;
	    second_f += 1000000;
	}
    } else {
	second_a += dxtime_data->second_a;

	second_f += dxtime_data->second_f;
	if (second_f < 1000000) {
	} else {
	    second_a++;
	    second_f -= 1000000;
	}
    }

    dxdate_data->time = second_a;
    dxdate_data->second_f = second_f;

    down_time = localtime(&second_a);

    dxdate_data->second_i = b6(down_time->tm_sec) | b6(down_time->tm_min) << 6
	| b5(down_time->tm_hour) << 12 | b5(down_time->tm_mday) << 17
	| b4(down_time->tm_mon) << 22;
    dxdate_data->second_l = b3(down_time->tm_wday)
	| b9(down_time->tm_yday) << 3 | down_time->tm_year << 12;

    return 0;
}
