/*
 * lxdate-a.l.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxdate-inter.h>
#include <nt.h>

int
x1f4_type_lxdate(struct x1f4_nodetype_type *nodetype_data, int cdate3)
{
    nodetype_data->code = cdate3;
    nodetype_data->name = "date";
    nodetype_data->size = 4;
    nodetype_data->flags = X1f4_LX_LINK_ACCESS;

    nodetype_data->copy = x1f4_copy_lxdate;
    nodetype_data->free = x1f4_free_lxdate;
    nodetype_data->lead = x1f4_lead_lxdate;
    nodetype_data->move = NULL;
    nodetype_data->node = x1f4_node_lxdate;
#if 0
    nodetype_data->post = NULL;
#endif				/* 0 */
    nodetype_data->push = x1f4_push_lxdate;
    nodetype_data->slip = x1f4_slip_lxdate;

    return 0;
}
