/*
 * lxdate-a.g.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxdate-inter.h>
#include <lxdate-types.h>

int
x1f4_line_lxdate(void *subtext, void **address)
{
    int status;
    struct lxdate_type *lxdate_data;
    void *dxdate;

    lxdate_data = subtext;

    status = lxdate_data->link_m.link
	(lxdate_data->link_m.data, &dxdate, sizeof(struct dxdate_type));
    if (status) {
	status = _libx1f4i0_lxdate_stat_link(lxdate_data);
    } else {
	((struct dxdate_type *) dxdate)->call = 1;

	*address = dxdate;
    }

    return status;
}
