/*
 * lxdate-a.c.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdate-inter.h>
#include <lxdate-types.h>

int
_libx1f4i0_lxdate_side_date(void *subtext, void *date)
{
    int status;
    struct dxdate_type *dxdate_data;

    dxdate_data = date;
    if (!dxdate_data) {
	/*
	 * dxdate_data may well be null... - test may not be removed.
	 */

	status = 0;
    } else {
	status = ((struct lxdate_type *) subtext)->link_m.free
	    (((struct lxdate_type *) subtext)->link_m.data, dxdate_data);
	if (status) {
	    status = _libx1f4i0_lxdate_stat_free(subtext);
	}
    }

    return status;
}
